/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.tools;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.core.lang.func.LambdaUtil;
import cn.hutool.core.util.ArrayUtil;
import com.bxm.newidea.component.param.PageParam;
import com.bxm.newidea.component.param.SortablePageParam;
import com.bxm.newidea.component.param.SortingField;
import java.util.Collections;

public class PageUtils {
    private static final Object[] ORDER_TYPES = new String[]{"asc", "desc"};

    public static int getStart(PageParam pageParam) {
        return (pageParam.getPageNo() - 1) * pageParam.getPageSize();
    }

    public static <T> SortingField buildSortingField(Func1<T, ?> func) {
        return PageUtils.buildSortingField(func, "desc");
    }

    public static <T> SortingField buildSortingField(Func1<T, ?> func, String order) {
        Assert.isTrue((boolean)ArrayUtil.contains((Object[])ORDER_TYPES, (Object)order), (String)String.format("\u5b57\u6bb5\u7684\u6392\u5e8f\u7c7b\u578b\u53ea\u80fd\u662f %s/%s", ORDER_TYPES), (Object[])new Object[0]);
        String fieldName = LambdaUtil.getFieldName(func);
        return new SortingField(fieldName, order);
    }

    public static <T> void buildDefaultSortingField(SortablePageParam sortablePageParam, Func1<T, ?> func) {
        if (sortablePageParam != null && CollUtil.isEmpty(sortablePageParam.getSortingFields())) {
            sortablePageParam.setSortingFields(Collections.singletonList(PageUtils.buildSortingField(func)));
        }
    }
}

