package com.bxm.newidea.component.model.param;

import com.bxm.newidea.component.param.BasicParam;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/6/8 2:17 下午
 */
public class PointParam {

    /**
     * 客户端设备ID
     */
    private String did;

    /**
     * 客户端版本号
     */
    private String v;

    /**
     * 事件编码
     */
    private String e;

    /**
     * 事件值
     */
    private String ev;

    /**
     * 上报的数据来源，固定值
     */
    private String p;

    /**
     * 请求的设备客户端类型
     */
    private String dtype;

    /**
     * 事件额外参数，key参见埋点事件文档定义，value为对应的值
     */
    private Map<String, String> extendMap;

    private PointParam() {
    }

    public static PointParam build() {
        PointParam param = new PointParam();
        param.p = "gold";
        param.extendMap = Maps.newHashMap();
        return param;
    }

    public static PointParam build(BasicParam basicParam) {
        PointParam param = build();
        param.dtype = String.valueOf(basicParam.getPlatform());
        param.did = String.valueOf(basicParam.getDevcId());
        param.v = basicParam.getCurVer();
        if (basicParam.getCliTime() != null) {
            param.put("ts", String.valueOf(basicParam.getCliTime()));
        } else {
            param.put("ts", String.valueOf(System.currentTimeMillis()));
        }
        return param;
    }

    public PointParam put(String key, String value) {
        extendMap.put(key, value);
        return this;
    }

    public Map<String, String> getMap() {
        extendMap.put("did", this.did);
        extendMap.put("e", this.e);
        extendMap.put("ev", this.ev);
        extendMap.put("v", this.v);
        extendMap.put("p", p);
        extendMap.put("dtype", this.dtype);
        return extendMap;
    }

    public PointParam did(String did) {
        this.did = did;
        return this;
    }

    public PointParam dtype(String dtype) {
        this.dtype = dtype;
        return this;
    }

    public PointParam v(String v) {
        this.v = v;
        return this;
    }

    public PointParam e(String e) {
        this.e = e;
        return this;
    }

    public PointParam ev(String ev) {
        this.ev = ev;
        return this;
    }

    public PointParam p(String p) {
        this.p = p;
        return this;
    }

    @Override
    public String toString() {
        return "PointParam{" +
                "did='" + did + '\'' +
                ", v='" + v + '\'' +
                ", e='" + e + '\'' +
                ", ev='" + ev + '\'' +
                ", p='" + p + '\'' +
                ", dtype='" + dtype + '\'' +
                ", extendMap=" + extendMap +
                '}';
    }
}