package com.bxm.newidea.component.service.impl;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.config.PointInfoProperties;
import com.bxm.newidea.component.model.param.PointParam;
import com.bxm.newidea.component.service.PointReportService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/6/8 2:15 下午
 */
@Service
@Slf4j
@AllArgsConstructor
public class PointReportServiceImpl implements PointReportService {

    private final PointInfoProperties pointInfoProperties;

    @Override
    public void add(PointParam param) {
        log.debug("report point:{}", param);

        Map<String, String> data = param.getMap();
        try {
            data.computeIfAbsent("v", k -> pointInfoProperties.getReportPointVersion());
            OkHttpUtils.postForm(pointInfoProperties.getReportPointUrl(), data, new HashMap<>());
        } catch (Exception e) {
            log.error("埋点上报失败，埋点内容：[{}]", JSON.toJSONString(data));
            log.error(e.getMessage(), e);
        }
    }
}