/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.util;

import com.bxm.newidea.component.config.PointInfoProperties;
import com.bxm.newidea.component.util.PointReportUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={PointInfoProperties.class})
public class PointConfiguration
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(PointConfiguration.class);
    private PointInfoProperties pointInfoProperties;

    public PointConfiguration(PointInfoProperties pointInfoProperties) {
        this.pointInfoProperties = pointInfoProperties;
    }

    public void run(ApplicationArguments args) {
        if (this.pointInfoProperties.getReportPointUrl() == null) {
            log.error("\u5f15\u5165\u4e86\u6253\u70b9\u7ec4\u4ef6\uff0c\u4f46\u662f\u672a\u63d0\u4f9b\u6253\u70b9\u4e0a\u4f20\u5730\u5740\uff1a[component.dot.reportPointUrl]");
        }
        if (this.pointInfoProperties.getProjectName() == null) {
            log.error("\u5f15\u5165\u4e86\u6253\u70b9\u7ec4\u4ef6\uff0c\u4f46\u662f\u672a\u63d0\u4f9b\u6253\u70b9\u5bf9\u5e94\u7684\u9879\u76ee\u540d\u79f0\uff1a[component.dot.projectName]\u3002\u53d6\u503c\u4e3a\u6570\u636e\u5e73\u53f0\u5bf9\u5e94\u7684\u540d\u79f0");
        }
        PointReportUtils.setPointInfoProperties(this.pointInfoProperties);
    }
}

