/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.util;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.config.PointInfoProperties;
import com.bxm.newidea.component.model.param.PointParam;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointReportUtils {
    private static final Logger log = LoggerFactory.getLogger(PointReportUtils.class);
    private static PointInfoProperties pointInfoProperties;

    private PointReportUtils() {
    }

    static void setPointInfoProperties(PointInfoProperties pointInfoProperties) {
        PointReportUtils.pointInfoProperties = pointInfoProperties;
    }

    public static void report(PointParam param) {
        Map<String, String> data = param.getFinalData();
        try {
            data.computeIfAbsent("v", k -> pointInfoProperties.getReportPointVersion());
            data.computeIfAbsent("p", k -> pointInfoProperties.getProjectName());
            OkHttpUtils.getWithDefaultHeader((String)pointInfoProperties.getReportPointUrl(), data);
            if (log.isDebugEnabled()) {
                log.debug("\u4e0a\u62a5\u6253\u70b9\u5b8c\u6210\uff0c\u65e5\u5fd7\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(data));
            }
        }
        catch (Exception e) {
            log.error("\u57cb\u70b9\u4e0a\u62a5\u5931\u8d25\uff0c\u57cb\u70b9\u5185\u5bb9\uff1a[{}]", (Object)JSON.toJSONString(data));
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

