package com.bxm.newidea.component.config;

import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.bxm.newidea.component.util.ReportConsumer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * 初始化工具类
 *
 * @author liujia
 * @date 6/9/21 1:52 PM
 **/
@Slf4j
@EnableConfigurationProperties(ComponentPointInfoProperties.class)
@Configuration
public class ComponentPointConfiguration {

    private ComponentPointInfoProperties pointInfoProperties;

    public static final String POINT_REPORT_TASK_EXECUTOR = "POINT_REPORT_TASK_EXECUTOR";

    public ComponentPointConfiguration(ComponentPointInfoProperties pointInfoProperties) {
        this.pointInfoProperties = pointInfoProperties;

        if (pointInfoProperties.getReportPointUrl() == null && pointInfoProperties.getProjectPointUrlMap() == null) {
            log.error("引入了数据埋点组件，但是未提供数据埋点上传地址：[component.dot.reportPointUrl]或[component.dot.projectPointUrlMap]");
        }

        if (pointInfoProperties.getProjectName() == null) {
            log.info("引入了数据埋点组件，但是未提供数据埋点对应的项目名称：[component.dot.projectName]。取值为数据平台对应的名称");
        }
    }

    @Bean
    public ReportConsumer reportConsume(@Qualifier(POINT_REPORT_TASK_EXECUTOR) Executor executor) {
        return new ReportConsumer(pointInfoProperties, executor);
    }

    @Bean(POINT_REPORT_TASK_EXECUTOR)
    @ConditionalOnMissingBean(name = POINT_REPORT_TASK_EXECUTOR)
    public Executor threadPoolTaskExecutor() {
        ComponentPointInfoProperties.PointThreadPollConfig threadPollConfig = pointInfoProperties.getThreadPollConfig();

        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(threadPollConfig.getCoreSize());
        executor.setMaxPoolSize(threadPollConfig.getMaxSize());
        executor.setQueueCapacity(threadPollConfig.getCapacity());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setThreadFactory(new NamedThreadFactory("component_point_report"));
        executor.setRejectedExecutionHandler(new RejectedExecutionHandler() {
            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                log.error("埋点任务超过了线程池的处理容量，Runnable：{},executor:{}", r, executor);
            }
        });
        return executor;
    }
}
