package com.bxm.newidea.component.util;

import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.config.ComponentPointInfoProperties;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;
import java.util.concurrent.Executor;

/**
 * @author liujia
 * @date 11/27/21 10:24 AM
 **/
@Slf4j
public class ReportConsumer {

    private ComponentPointInfoProperties pointInfoProperties;

    private Executor executor;

    public ReportConsumer(ComponentPointInfoProperties pointInfoProperties, Executor executor) {
        this.pointInfoProperties = pointInfoProperties;
        this.executor = executor;
        PointReportUtils.setReportConsumer(this);
    }

    void consume(Map<String, String> data) {
        try {
            executor.execute(() -> {
                String projectName = data.computeIfAbsent("p", k -> pointInfoProperties.getProjectName());

                String version = pointInfoProperties.getProjectVersionMap().get(projectName);
                if (null != version) {
                    data.put("v", version);
                } else {
                    data.computeIfAbsent("v", k -> pointInfoProperties.getReportPointVersion());
                }

                String url = pointInfoProperties.getProjectPointUrlMap().get(projectName);
                if (null == url) {
                    url = pointInfoProperties.getReportPointUrl();
                }

                String queryParam = HttpUtil.toParams(data);
                String finalUrl = url;
                if (url.contains("?")) {
                    finalUrl += "&";
                } else {
                    finalUrl += "?";
                }
                finalUrl += queryParam;

                HttpUtil.get(finalUrl, 1500);

                if (log.isDebugEnabled()) {
                    log.debug("上报数据埋点完成，日志参数：{}", finalUrl);
                }
            });
        } catch (Exception e) {
            log.error("埋点上报失败，埋点内容：[{}]", data);
            log.error(e.getMessage(), e);
        }
    }
}
