package com.bxm.component.elasticjob.job;

/**
 * 分片作业的定时任务
 *
 * @author liujia
 * @date 6/9/21 7:30 PM
 **/
public interface IShardingElasticJob extends ISimplifyElasticJob {

    /**
     * 分片数量总数。分片的数量根据顺序分配给可用的执行器
     *
     * @return 分片数量
     */
    int shardingTotalCount();

    /**
     * 分片参数，eg：0=Beijing,1=Shanghai,2=Guangzhou
     * 实现接口中，根据得到的分片选项值进行处理，从而实现分片作业
     * 分片下标从0开始，也可以只用下标
     * shardingContext.getShardingItem()：代表被分片的片区,eg:0
     * shardingContext.getShardingParameter()：代表被对应的参数,eg:Beijing
     *
     * @return 分片参数
     */
    String shardingItemParameters();
}
