/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.emoji;

import com.bxm.newidea.component.emoji.EmojiCodeManager;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class EmojiCodeParser {
    private static final Pattern PATTERN = Pattern.compile("([\\uE000-\\uEFFF])");

    public static boolean hasSoftbankEmoji(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Matcher matcher = PATTERN.matcher(str);
        return matcher.find();
    }

    public static String replaceSoftbankEmoji(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        Matcher matcher = PATTERN.matcher(str);
        HashMap<String, String> keyMap = new HashMap<String, String>();
        while (matcher.find()) {
            String key = matcher.group();
            String value = EmojiCodeManager.getEmojiCodeMapValue(key);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            keyMap.put(key, value);
        }
        if (keyMap.size() > 0) {
            for (Map.Entry entry : keyMap.entrySet()) {
                str = str.replaceAll((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return str;
    }
}

