package com.bxm.newidea.component.tools;

import com.vdurmont.emoji.EmojiParser;

import java.util.List;

public class CharUtil {

    /**
     * 计算一串字符是否达到某阀值
     * 判断字母：str.charAt(i))>='A' && (str.charAt(i))<='Z') || ((str.charAt(i))>='a' && (str.charAt(i))<='z')
     * 判断数字：str.charAt(i)>='0' && str.charAt(i)<='9'
     * 判断汉字：str.charAt(i)>=0x4e00 && str.charAt(i)<=0x9fbb
     *
     * @param origin 源字符串
     * @param n      达标的个数
     * @return 是否满足达标
     */
    public static boolean isCharSatisfied(String origin, int n) {
        int c = 0;
        for (int i = 0; i < origin.length(); i++) {
            char originChar = origin.charAt(i);
            if ((originChar >= 'A' && originChar <= 'Z') || (originChar >= 'a' && originChar <= 'z')) {
                c++;
            } else
                //判断数字
                if (originChar >= '0' && originChar <= '9') {
                    c++;
                } else
                    //判断汉字
                    if (originChar >= 0x4e00 && originChar <= 0x9fbb) {
                        c++;
                    }
            if (c >= n) {
                return true;
            }
        }
        return false;
    }

    /**
     * 计算字数，简单实现
     * 中文 =1
     * 中文字符 =1
     * 英文字符 =1
     * 英文数字 =1
     * emoji =1
     *
     * @param source
     * @return
     */
    public static int getWordCount(String source) {
        List<String> emojiList = EmojiParser.extractEmojis(source);
        source = EmojiParser.removeAllEmojis(source);

        return source.length() + emojiList.size();

    }

}
