package com.bxm.newidea.component.geo.service;

import com.bxm.newidea.component.geo.dto.CoordinateDTO;
import com.bxm.newidea.component.geo.dto.DistanceDTO;

import java.util.List;

/**
 * 地理位置相关接口
 */
public interface GeoService {

    /**
     * 用途：获得多个出发点与目的地的距离，经纬度精度不得超过6位
     * 场景：当用户点开优惠列表时，显示与用户所在地的距离信息
     * @param origins 出发点,支持100个坐标点,包含经纬度，用逗号隔开
     * @param destination 目的地
     * @return
     */
    List<DistanceDTO> getDistance(List<String> origins, String destination);


    /**
     * 用途：获得单个出发点与目的地的距离，经纬度精度不得超过6位
     * 场景：当用户点开优惠列表时，显示与用户所在地的距离信息
     * @param origins 出发点,包含经纬度，用逗号隔开 116.481028,39.989643
     * @param destination 目的地,包含经纬度，用逗号隔开 114.465302,40.004717
     * @return
     */
    Long getDistance(String origins, String destination);

    /**
     * 根据地址获取经纬度信息 填写结构化地址信息:省份＋城市＋区县＋城镇＋乡村＋街道＋门牌号码
     * 场景：得到商户所在地的经纬度信息
     * @param address 详细地址
     * @return
     */
    CoordinateDTO getLatitudeAndLongitude(String address);
}
