package com.bxm.newidea.component.geo.dto;

/**
 * 地区信息实体
 */
public class LocationInfoDTO {

    /**
     * 详细地址
     * 如：北京市朝阳区方恒国际中心|A座
     */
    private String formattedAddress;

    /**
     * 省份
     * 如：北京市
     */
    private String province;

    /**
     * 城市编码
     * 如：010
     */
    private String citycode;

    /**
     * 城市
     * 如：北京
     */
    private String city;

    /**
     * 地址所在的区
     * 如：朝阳区
     */
    private String district;

    /**
     * 地址所在的区的编码
     * 如：110105
     */
    private String adcode;

    /**
     * 坐标实体（包含经纬度）
     */
    private Coordinate coordinate;

    public String getFormattedAddress() {
        return formattedAddress;
    }

    public void setFormattedAddress(String formattedAddress) {
        this.formattedAddress = formattedAddress;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCitycode() {
        return citycode;
    }

    public void setCitycode(String citycode) {
        this.citycode = citycode;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getAdcode() {
        return adcode;
    }

    public void setAdcode(String adcode) {
        this.adcode = adcode;
    }

    public Coordinate getCoordinate() {
        return coordinate;
    }

    public void setCoordinate(Coordinate coordinate) {
        this.coordinate = coordinate;
    }
}
