/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.geo.service.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.newidea.component.geo.config.GeoProperties;
import com.bxm.newidea.component.geo.dto.Coordinate;
import com.bxm.newidea.component.geo.service.GeoService;
import com.bxm.newidea.component.tools.LocationUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GeoServiceImpl
implements GeoService {
    @Autowired
    HttpClientService httpClientService;
    @Autowired
    GeoProperties geoProperties;

    @Override
    public Long getDistance(Coordinate origins, Coordinate destination) {
        if (this.isCoordinateEmpty(origins, destination)) {
            return null;
        }
        Double distance = LocationUtils.getDistance((double)origins.getLatitude(), (double)origins.getLongitude(), (double)destination.getLatitude(), (double)destination.getLongitude());
        return distance.longValue();
    }

    boolean isCoordinateEmpty(Coordinate origins, Coordinate destination) {
        return origins.getLatitude() == null || origins.getLongitude() == null || destination.getLatitude() == null || destination.getLongitude() == null;
    }

    @Override
    public Coordinate getCoordinate(String address) {
        JSONObject jsonObject;
        Coordinate coordinate = null;
        HashMap map = Maps.newHashMap();
        map.put("key", this.geoProperties.getKey());
        map.put("address", address);
        String json = this.httpClientService.doGet(this.geoProperties.getGeoUrl(), (Map)map);
        if (null != json && (jsonObject = JSONObject.parseObject((String)json)) != null) {
            String status = jsonObject.getString("status");
            String count = jsonObject.getString("count");
            if ("1".equalsIgnoreCase(status) && "1".equals(count)) {
                JSONObject geocode = jsonObject.getJSONArray("geocodes").getJSONObject(0);
                String location = geocode.getString("location");
                String[] coordinateArray = location.split(",");
                coordinate = new Coordinate();
                coordinate.setLongitude(Double.valueOf(coordinateArray[0]));
                coordinate.setLatitude(Double.valueOf(coordinateArray[1]));
            }
        }
        return coordinate;
    }
}

