/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.geo.service.impl;

import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSONObject;
import com.bxm.newidea.component.config.GeoProperties;
import com.bxm.newidea.component.geo.dto.AddressComponentDTO;
import com.bxm.newidea.component.geo.dto.CoordinateDTO;
import com.bxm.newidea.component.geo.param.GeoPoint;
import com.bxm.newidea.component.geo.service.GeoService;
import com.bxm.newidea.component.tools.GouldUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GeoServiceImpl
implements GeoService {
    private static final Logger log = LoggerFactory.getLogger(GeoServiceImpl.class);
    private final GeoProperties geoProperties;

    @Override
    public Double getDistance(GeoPoint origins, GeoPoint destination) {
        if (this.isCoordinateEmpty(origins, destination)) {
            return -1.0;
        }
        return GouldUtils.getDistance(origins.getLat(), origins.getLng(), destination.getLat(), destination.getLng());
    }

    @Override
    public CoordinateDTO getCoordinate(String address) {
        if (Objects.isNull(address)) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        map.put("key", this.geoProperties.getKey());
        map.put("address", address);
        String json = HttpUtil.get((String)this.geoProperties.getGeoUrl(), (Map)map);
        if (Objects.isNull(json)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        if (Objects.isNull(jsonObject)) {
            return null;
        }
        CoordinateDTO coordinate = null;
        String status = jsonObject.getString("status");
        String count = jsonObject.getString("count");
        if ("1".equalsIgnoreCase(status) && "1".equals(count)) {
            JSONObject geocode = jsonObject.getJSONArray("geocodes").getJSONObject(0);
            String location = geocode.getString("location");
            String[] coordinateArray = location.split(",");
            coordinate = new CoordinateDTO();
            coordinate.setLongitude(Double.valueOf(coordinateArray[0]));
            coordinate.setLatitude(Double.valueOf(coordinateArray[1]));
        }
        return coordinate;
    }

    @Override
    public Boolean isWithinTheScopeOf(GeoPoint origins, GeoPoint destination, Long radius) {
        if (this.isCoordinateEmpty(origins, destination)) {
            return false;
        }
        return GouldUtils.isWithinTheScopeOf(origins.getLng(), origins.getLat(), destination.getLng(), destination.getLat(), radius);
    }

    @Override
    public Boolean isInArea(GeoPoint origins, GeoPoint area1, GeoPoint area2) {
        return GouldUtils.isInArea(origins.getLat(), origins.getLng(), area1.getLat(), area2.getLat(), area1.getLng(), area2.getLng());
    }

    @Override
    public AddressComponentDTO getAddress(GeoPoint point) {
        HashMap map = Maps.newHashMap();
        map.put("output", "JSON");
        map.put("location", point.getLng() + "," + point.getLat());
        map.put("key", this.geoProperties.getKey());
        map.put("radius", 0);
        map.put("extensions", "base");
        String json = HttpUtil.get((String)this.geoProperties.getRegeoUrl(), (Map)map);
        if (Objects.isNull(json)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        if (null == jsonObject || 1 != jsonObject.getInteger("status")) {
            log.warn("\u89e3\u6790\u7ecf\u7eac\u5ea6\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{},\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)point, (Object)jsonObject);
            return null;
        }
        JSONObject regexCode = jsonObject.getJSONObject("regeocode");
        if (regexCode.size() <= 0) {
            return null;
        }
        String formatted = regexCode.getString("formatted_address");
        JSONObject addressComponent = regexCode.getJSONObject("addressComponent");
        AddressComponentDTO dto = (AddressComponentDTO)JSONObject.parseObject((String)addressComponent.toJSONString(), AddressComponentDTO.class);
        if (Objects.isNull(dto)) {
            dto = new AddressComponentDTO();
        }
        dto.setLat(point.getLat());
        dto.setLng(point.getLng());
        dto.setFormattedAddress(formatted);
        return dto;
    }

    private boolean isCoordinateEmpty(GeoPoint origins, GeoPoint destination) {
        if (Objects.isNull(origins) || Objects.isNull(destination)) {
            return true;
        }
        return origins.getLat() == null || origins.getLng() == null || destination.getLat() == null || destination.getLng() == null;
    }

    public GeoServiceImpl(GeoProperties geoProperties) {
        this.geoProperties = geoProperties;
    }
}

