package com.bxm.component.auto.registry.spring.cloud;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author Gonzo
 * @date 2019-12-04 17:11
 */
@Data
@Component
@ConfigurationProperties("component.spring.cloud.service-registry")
public class EurekaClientServiceRegistryProperties {

    /**
     * Eureka服务线下之后，等待多长时间再执行原有的shutdown, 默认30s
     */
    private long afterOutOfServiceWaitTimeSecond = 30;

}
