package com.bxm.component.httpclient.service.impl;

import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.newidea.component.constant.EncodedConstant;
import com.bxm.newidea.component.service.BaseService;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * httpclient实现
 * @deprecated 推荐使用okhttp
 */
@Service("httpClientService")
@Deprecated
public class HttpClientServiceImpl extends BaseService implements HttpClientService {

    private static final int CODE = 200;

    private final CloseableHttpClient httpClient;

    @Autowired
    public HttpClientServiceImpl(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public String doGet(String url) {
        CloseableHttpResponse response = null;
        String resultStr = "";
        try {
            //创建get请求
            HttpGet httpGet = new HttpGet(url);
            response = httpClient.execute(httpGet);
            if (response.getStatusLine().getStatusCode() == CODE) {
                resultStr = EntityUtils.toString(response.getEntity(), EncodedConstant.UTF8);
            }
        } catch (IOException e) {
            logger.error(e.getMessage(), e);
        } finally {
            this.closeResource(response);
        }
        return resultStr;
    }

    @Override
    public String doGet(String url, Map<String, String> params) {
        String resultStr = "";
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            for (String key : params.keySet()) {
                uriBuilder.addParameter(key, params.get(key));
            }
            resultStr = this.doGet(uriBuilder.build().toString());
        } catch (URISyntaxException e) {
            logger.error(e.getMessage(), e);
        }
        return resultStr;
    }

    @Override
    public String doPost(String url, Map<String, String> params) {
        // 创建Httpclient对象
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建Http Post请求
            HttpPost httpPost = new HttpPost(url);
            // 创建参数列表
            if (params != null) {
                List<NameValuePair> paramList = new ArrayList<>();
                for (String key : params.keySet()) {
                    paramList.add(new BasicNameValuePair(key, params.get(key)));
                }
                // 模拟表单
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList);
                httpPost.setEntity(entity);
            }
            // 执行http请求
            response = httpClient.execute(httpPost);
            resultString = EntityUtils.toString(response.getEntity(), EncodedConstant.UTF8);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        } finally {
            this.closeResource(response);
        }

        return resultString;
    }

    @Override
    public String doPost(String url, String content) {
        // 创建Httpclient对象
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建Http Post请求
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(content, EncodedConstant.UTF8);
            httpPost.setEntity(entity);
            // 执行http请求
            response = httpClient.execute(httpPost);
            resultString = EntityUtils.toString(response.getEntity(), EncodedConstant.UTF8);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        } finally {
            this.closeResource(response);
        }

        return resultString;
    }

    @Override
    public String doPostJson(String url, String json) {
        // 创建Httpclient对象
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建Http Post请求
            HttpPost httpPost = new HttpPost(url);
            // 创建请求内容
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity(entity);
            // 执行http请求
            response = httpClient.execute(httpPost);
            resultString = EntityUtils.toString(response.getEntity(), EncodedConstant.UTF8);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        } finally {
            this.closeResource(response);
        }
        return resultString;
    }

    /**
     * 关闭资源
     * @param response 响应
     */
    private void closeResource(CloseableHttpResponse response) {
        try {
            if (response != null) {
                response.close();
            }
        } catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
    }

}
