package com.huawei.push.javasdk.message;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.push.javasdk.util.ValidatorUtils;
import org.apache.commons.lang3.StringUtils;

public class AndroidConfig {

    private static final String TTL_PATTERN = "\\d+|\\d+[sS]|\\d+.\\d{1,9}|\\d+.\\d{1,9}[sS]";

    @JSONField(name = "collapse_key")
    private Integer collapseKey;

    @JSONField(name = "ttl")
    private String ttl;

    @JSONField(name = "bi_tag")
    private String biTag;

    @JSONField(name = "fast_app_target")
    private Integer fastAppTargetType;

    @JSONField(name = "notification")
    private AndroidNotification notification;

    public AndroidConfig(Builder builder) {
        this.collapseKey = builder.collapseKey;

        if (null != builder.ttl) {
            this.ttl = builder.ttl;
        } else {
            this.ttl = null;
        }

        this.biTag = builder.biTag;
        this.fastAppTargetType = builder.fastAppTargetType;
        this.notification = builder.notification;
    }

    /**
     * check androidConfig's parameters
     * @param notification whcic is in message
     */
    public void check(Notification notification) {
        if (this.fastAppTargetType != null) {
            ValidatorUtils.checkArgument(this.fastAppTargetType == 1 || this.fastAppTargetType == 2, "Invalid fast app target type[one of 1 or 2]");
        }

        if (this.collapseKey != null) {
            ValidatorUtils.checkArgument((this.collapseKey >= -1 && this.collapseKey <= 100), "Collapse Key should be [-1, 100]");
        }

        if (StringUtils.isNotEmpty(this.ttl)) {
            ValidatorUtils.checkArgument(this.ttl.matches(AndroidConfig.TTL_PATTERN), "The TTL's format is wrong");
        }

        if (null != this.notification) {
            this.notification.check(notification);
        }
    }

    /**
     * getter
     */
    public Integer getCollapseKey() {
        return collapseKey;
    }

    public String getTtl() {
        return ttl;
    }

    public String getBiTag() {
        return biTag;
    }

    public Integer getFastAppTargetType() {
        return fastAppTargetType;
    }

    public AndroidNotification getNotification() {
        return notification;
    }

    /**
     * builder
     */
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer collapseKey;
        private String ttl;
        private String biTag;
        private Integer fastAppTargetType;
        private AndroidNotification notification;

        private Builder() {}

        public Builder setCollapseKey(Integer collapseKey) {
            this.collapseKey = collapseKey;
            return this;
        }

        /**
         * time-to-live
         */
        public Builder setTtl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder setBiTag(String biTag) {
            this.biTag = biTag;
            return this;
        }

        public Builder setFastAppTargetType(Integer fastAppTargetType) {
            this.fastAppTargetType = fastAppTargetType;
            return this;
        }

        public Builder setNotification(AndroidNotification notification) {
            this.notification = notification;
            return this;
        }

        public AndroidConfig build() {
            return new AndroidConfig(this);
        }
    }
}
