package com.huawei.push.javasdk.util;

import java.util.HashMap;
import java.util.Map;

/**
 * A utility for processing the responce code
 */
public class ResponceCodeProcesser {
    private static final Map<Integer, String> codeMap = new HashMap<Integer, String>();

    static {
        codeMap.put(80000000, "Success");
        codeMap.put(80200001, "Oauth authentication error");
        codeMap.put(80200003, "Oauth Token expired");
        codeMap.put(80100003, "Message structure error");
        codeMap.put(80300008, "The message body size exceeds the default value set by the system (4K)");
        codeMap.put(80300002, "APP is forbidden to send");
        codeMap.put(80300007, "Invalid Token");
    }

    ;

    public static String process(Integer code) {
        return codeMap.getOrDefault(code, "Unknown code");
    }
}
