/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.javasdk.messaging;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class HuaweiScheduledExecutor
extends ScheduledThreadPoolExecutor {
    public HuaweiScheduledExecutor(ThreadFactory threadFactory, String name) {
        this(threadFactory, name, null);
    }

    public HuaweiScheduledExecutor(ThreadFactory threadFactory, String name, Thread.UncaughtExceptionHandler handler) {
        super(1, HuaweiScheduledExecutor.decorateThreadFactory(threadFactory, name, handler));
        this.setRemoveOnCancelPolicy(true);
    }

    static ThreadFactory getThreadFactoryWithName(ThreadFactory threadFactory, String name) {
        return HuaweiScheduledExecutor.decorateThreadFactory(threadFactory, name, null);
    }

    private static ThreadFactory decorateThreadFactory(ThreadFactory threadFactory, String name, Thread.UncaughtExceptionHandler handler) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setThreadFactory(threadFactory).setNameFormat(name).setDaemon(true);
        if (handler != null) {
            builder.setUncaughtExceptionHandler(handler);
        }
        return builder.build();
    }
}

