package com.bxm.newidea.component;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * @author lowi
 * @date 2021/3/3 9:46
 */
public class JSON {

    private final static ObjectMapper objectMapper;


    static {
        objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    }

    public static ObjectMapper addConfigure(SerializationFeature f, boolean state) {
        objectMapper.configure(f, state);
        return objectMapper;
    }

    public static ObjectMapper addConfigure(JsonInclude.Include jsonInclude) {
        objectMapper.setSerializationInclusion(jsonInclude);
        return objectMapper;
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }


    public static String toJSONString(Object value) {
        try {
            return objectMapper.writeValueAsString(value);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return null;
    }


    public static Object parse(String text) {
        try {
            return objectMapper.readValue(text, Object.class);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object parse(String text, JsonParser.Feature... feature) {
        try {
            ObjectMapper disable = objectMapper.disable(feature);
            return disable.readValue(text, Object.class);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object parse(byte[] src) {
        try {
            return objectMapper.readValue(src, Object.class);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object parse(byte[] src, int offset, int len) {
        try {
            return objectMapper.readValue(src, offset, len, Object.class);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> Object parse(byte[] src, TypeReference<T> valueTypeRef) {
        try {
            return objectMapper.readValue(src, valueTypeRef);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> Object parse(byte[] src, int offset, int len, TypeReference<T> valueTypeRef) {
        try {
            return objectMapper.readValue(src, offset, len, valueTypeRef);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> Object parse(byte[] src, JavaType javaType) {
        try {
            return objectMapper.readValue(src, javaType);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JSONObject parseObject(String text) {
        try {
            return objectMapper.readValue(text, JSONObject.class);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JSONObject parseObject(String text, JsonParser.Feature... feature) {
        try {
            ObjectMapper disable = objectMapper.disable(feature);
            return disable.readValue(text, JSONObject.class);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        try {
            return objectMapper.readValue(text, clazz);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> T parseObject(InputStream in, Class<T> clazz) {
        try {
            return objectMapper.readValue(in, clazz);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> T parseObject(byte[] src, Class<T> clazz) {
        try {
            return objectMapper.readValue(src, clazz);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> T toJavaObject(JSONObject json, Class<T> clazz) {
        try {
            return objectMapper.readValue(JSON.toJSONString(json), clazz);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> T parseArray(String text, TypeReference<T> valueTypeRef) {
        try {
            return objectMapper.readValue(text, valueTypeRef);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> List<T> parseArray(String value, Class<T> clazz) {
        JSONArray objects = JSON.parseArray(value);
        List<T> list = new ArrayList<T>(objects.size());
        for (Object item : objects) {
            list.add(JSON.parseObject(JSON.toJSONString(item), clazz));
        }
        return list;
    }

    public static <T> T parseObject(String text, TypeReference<T> valueTypeRef) {
        try {
            return objectMapper.readValue(text, valueTypeRef);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JSONArray parseArray(String text) {
        try {
            return objectMapper.readValue(text, new TypeReference<JSONArray>() {
            });
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] toJSONBytes(Object obj) {
        try {
            return objectMapper.writeValueAsBytes(obj);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object toJSON(Object obj) {
        try {
            return objectMapper.readValue(JSON.toJSONString(obj), Object.class);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }


}
