/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component;

import com.bxm.newidea.component.JSONArray;
import com.bxm.newidea.component.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSON {
    private static final Logger log = LoggerFactory.getLogger(JSON.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static ObjectMapper addConfigure(SerializationFeature f, boolean state) {
        objectMapper.configure(f, state);
        return objectMapper;
    }

    public static ObjectMapper addConfigure(DeserializationFeature f, boolean state) {
        objectMapper.configure(f, state);
        return objectMapper;
    }

    public static ObjectMapper addConfigure(JsonInclude.Include jsonInclude) {
        objectMapper.setSerializationInclusion(jsonInclude);
        return objectMapper;
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static String toJSONString(Object value) {
        if (JSON.validationValue(value)) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            log.warn("JSON.toJSONString\u51fa\u9519\uff0c\u8bf7\u6c42\u53c2\u6570Object\uff1aparam:{}", value, (Object)e);
            return null;
        }
    }

    public static Object parse(String text) {
        if (JSON.validationValue(text)) {
            return null;
        }
        try {
            return objectMapper.readValue(text, Object.class);
        }
        catch (IOException e) {
            log.warn("JSON.parse\u51fa\u9519\uff0c\u8bf7\u6c42\u53c2\u6570String\uff1aparam:{}", (Object)text, (Object)e);
            return null;
        }
    }

    public static Object parse(String text, JsonParser.Feature ... feature) {
        if (JSON.validationValue(text)) {
            return null;
        }
        try {
            ObjectMapper disable = objectMapper.enable(feature);
            return disable.readValue(text, Object.class);
        }
        catch (IOException e) {
            log.warn("JSON.parse\u51fa\u9519\uff0c\u8bf7\u6c42\u53c2\u6570String\uff1aparam:{},JsonParser.Feature:{}", new Object[]{text, feature, e});
            return null;
        }
    }

    public static Object parse(byte[] src) {
        if (JSON.validationValue(src)) {
            return null;
        }
        try {
            return objectMapper.readValue(src, Object.class);
        }
        catch (IOException e) {
            log.warn("JSON.parse\u51fa\u9519\uff0c\u8bf7\u6c42\u53c2\u6570byte[]\uff1aparam:{}", (Object)src, (Object)e);
            return null;
        }
    }

    public static Object parse(byte[] src, int offset, int len) {
        if (JSON.validationValue(src)) {
            return null;
        }
        try {
            return objectMapper.readValue(src, offset, len, Object.class);
        }
        catch (IOException e) {
            log.warn("JSON.parse\u51fa\u9519\uff0c\u8bf7\u6c42\u53c2\u6570byte[]\uff1a{},offset:{},len:{}", new Object[]{src, offset, len, e});
            return null;
        }
    }

    public static <T> Object parse(byte[] src, TypeReference<T> valueTypeRef) {
        if (JSON.validationValue(src)) {
            return null;
        }
        try {
            return objectMapper.readValue(src, valueTypeRef);
        }
        catch (IOException e) {
            log.warn("JSON.parse\u51fa\u9519\uff0c\u8bf7\u6c42\u53c2\u6570byte[]\uff1a{},TypeReference<T>:{}", new Object[]{src, valueTypeRef, e});
            return null;
        }
    }

    public static <T> Object parse(byte[] src, int offset, int len, TypeReference<T> valueTypeRef) {
        if (JSON.validationValue(src)) {
            return null;
        }
        try {
            return objectMapper.readValue(src, offset, len, valueTypeRef);
        }
        catch (IOException e) {
            log.warn("JSON.parse\u51fa\u9519\uff0c\u8bf7\u6c42\u53c2\u6570byte[]\uff1a{},offset:{},len:{},TypeReference<T>:{}", new Object[]{src, offset, len, valueTypeRef, e});
            return null;
        }
    }

    public static <T> Object parse(byte[] src, JavaType javaType) {
        if (JSON.validationValue(src)) {
            return null;
        }
        try {
            return objectMapper.readValue(src, javaType);
        }
        catch (IOException e) {
            log.warn("JSON.parse\u51fa\u9519\uff0c\u8bf7\u6c42\u53c2\u6570byte[]\uff1a{},javaType:{}", new Object[]{src, javaType, e});
            return null;
        }
    }

    public static JSONObject parseObject(String text) {
        if (JSON.validationValue(text)) {
            return null;
        }
        try {
            return (JSONObject)objectMapper.readValue(text, JSONObject.class);
        }
        catch (IOException e) {
            log.warn("JSON.parseObject\u51fa\u9519\uff0c\u8bf7\u6c42\u53c2\u6570text:{}", (Object)text, (Object)e);
            return null;
        }
    }

    public static JSONObject parseObject(String text, JsonParser.Feature ... feature) {
        if (JSON.validationValue(text)) {
            return null;
        }
        try {
            ObjectMapper disable = objectMapper.enable(feature);
            return (JSONObject)disable.readValue(text, JSONObject.class);
        }
        catch (IOException e) {
            log.warn("JSON.parseObject\u51fa\u9519\uff0c\u8bf7\u6c42\u53c2\u6570text:{},JsonParser.Feature:{}", new Object[]{text, feature, e});
            return null;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        if (JSON.validationValue(text)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(text, clazz);
        }
        catch (IOException e) {
            log.warn("JSON.parseObject\u51fa\u9519\uff0c\u8bf7\u6c42\u53c2\u6570text:{},Class<T>:{}", new Object[]{text, clazz, e});
            return null;
        }
    }

    public static <T> T parseObject(InputStream in, Class<T> clazz) {
        if (JSON.validationValue(in)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(in, clazz);
        }
        catch (IOException e) {
            log.warn("JSON.parseObject\u51fa\u9519\uff0cInputStream:{},Class<T>:{}", new Object[]{in, clazz, e});
            return null;
        }
    }

    public static <T> T parseObject(byte[] src, Class<T> clazz) {
        if (JSON.validationValue(src)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(src, clazz);
        }
        catch (IOException e) {
            log.warn("JSON.parseObject\u51fa\u9519\uff0cbyte[]:{},Class<T>:{}", new Object[]{src, clazz, e});
            return null;
        }
    }

    public static <T> T toJavaObject(JSONObject json, Class<T> clazz) {
        if (JSON.validationValue(json)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(JSON.toJSONString(json), clazz);
        }
        catch (Exception e) {
            log.warn("JSON.toJavaObject\u51fa\u9519\uff0cJSONObject:{},Class<T>:{}", new Object[]{json, clazz, e});
            return null;
        }
    }

    public static <T> T parseArray(String text, TypeReference<T> valueTypeRef) {
        if (JSON.validationValue(text)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(text, valueTypeRef);
        }
        catch (IOException e) {
            log.warn("JSON.parseArray\u51fa\u9519\uff0ctext:{},TypeReference<T>:{}", new Object[]{text, valueTypeRef, e});
            return null;
        }
    }

    public static <T> List<T> parseArray(String value, Class<T> clazz) {
        if (JSON.validationValue(value)) {
            return null;
        }
        JSONArray objects = JSON.parseArray(value);
        ArrayList<T> list = new ArrayList<T>(objects.size());
        for (Object item : objects) {
            list.add(JSON.parseObject(JSON.toJSONString(item), clazz));
        }
        return list;
    }

    public static <T> T parseObject(String text, TypeReference<T> valueTypeRef) {
        if (JSON.validationValue(text)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(text, valueTypeRef);
        }
        catch (IOException e) {
            log.warn("JSON.parseObject\u51fa\u9519\uff0ctext:{},TypeReference<T>:{}", new Object[]{text, valueTypeRef, e});
            return null;
        }
    }

    public static JSONArray parseArray(String text) {
        if (JSON.validationValue(text)) {
            return null;
        }
        try {
            return (JSONArray)objectMapper.readValue(text, (TypeReference)new TypeReference<JSONArray>(){});
        }
        catch (IOException e) {
            log.warn("JSON.parseArray\u51fa\u9519\uff0ctext:{}", (Object)text, (Object)e);
            return null;
        }
    }

    public static byte[] toJSONBytes(Object obj) {
        if (JSON.validationValue(obj)) {
            return null;
        }
        try {
            return objectMapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            log.warn("JSON.toJSONBytes\u51fa\u9519\uff0cobj:{}", obj, (Object)e);
            return null;
        }
    }

    public static Object toJSON(Object obj) {
        if (JSON.validationValue(obj)) {
            return null;
        }
        try {
            return objectMapper.readValue(JSON.toJSONString(obj), Object.class);
        }
        catch (IOException e) {
            log.warn("JSON.toJSON\u51fa\u9519\uff0cobj:{}", obj, (Object)e);
            return null;
        }
    }

    private static boolean validationValue(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return "".equals(obj.toString());
        }
        return false;
    }

    static {
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES});
        objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS});
        objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS});
        objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
        objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS});
    }
}

