/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.jwt.util;

import com.bxm.component.jwt.bo.JwtTokenBO;
import com.bxm.component.jwt.builder.TokenBuildParam;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.Jwts;
import java.util.Map;

public class JwtUtil {
    private JwtUtil() {
    }

    public static String generateToken(TokenBuildParam buildParam) {
        return Jwts.builder().setHeader(buildParam.getHeaderMap()).setClaims(buildParam.getClaimMap()).setExpiration(buildParam.getExpirationTime()).setIssuedAt(buildParam.getIssueDate()).signWith(buildParam.getSignatureAlgorithm(), buildParam.getSignatureKey()).compact();
    }

    public static JwtTokenBO parseToken(String token, String signatureKey) {
        Jwt jwt = Jwts.parser().setSigningKey(signatureKey).parse(token);
        JwtTokenBO tokenBO = new JwtTokenBO();
        Object body = jwt.getBody();
        if (body instanceof Claims) {
            tokenBO.setBody((Map<String, Object>)((Claims)body));
        }
        tokenBO.setHeader(jwt.getHeader());
        return tokenBO;
    }
}

