/*
 * Decompiled with CFR 0.152.
 */
package com.bxm;

import cn.hutool.core.util.RandomUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication
public class Application {
    private static final Logger log = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
        Application.createLog();
    }

    public static void createLog() {
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 10; ++i) {
            executorService.submit(() -> {
                while (true) {
                    int level;
                    if ((level = RandomUtil.randomInt()) % 5 == 0) {
                        log.info("{}", (Object)level);
                    } else if (level % 4 == 0) {
                        log.debug("{}", (Object)level);
                    } else if (level % 3 == 0) {
                        log.error("{}", (Object)level);
                    } else if (level % 2 == 0) {
                        log.warn("{}", (Object)level);
                    }
                    TimeUnit.MILLISECONDS.sleep(50L);
                }
            });
        }
    }
}

