/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mircometer.log4j2;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;

public class InstrumentedAppender
extends AbstractAppender {
    private static final String METER_NAME = "log4j2.event.count";
    private Counter trace;
    private Counter debug;
    private Counter info;
    private Counter warn;
    private Counter error;
    private Counter fatal;
    private MeterRegistry registry;

    public InstrumentedAppender(String name, MeterRegistry registry, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        this.registry = registry;
    }

    public void start() {
        this.trace = Counter.builder((String)METER_NAME).tags(new String[]{"level", "trace"}).register(this.registry);
        this.debug = Counter.builder((String)METER_NAME).tags(new String[]{"level", "debug"}).register(this.registry);
        this.info = Counter.builder((String)METER_NAME).tags(new String[]{"level", "info"}).register(this.registry);
        this.warn = Counter.builder((String)METER_NAME).tags(new String[]{"level", "warn"}).register(this.registry);
        this.error = Counter.builder((String)METER_NAME).tags(new String[]{"level", "error"}).register(this.registry);
        this.fatal = Counter.builder((String)METER_NAME).tags(new String[]{"level", "fatal"}).register(this.registry);
        super.start();
    }

    public void append(LogEvent event) {
        switch (event.getLevel().getStandardLevel()) {
            case TRACE: {
                this.trace.increment();
                break;
            }
            case DEBUG: {
                this.debug.increment();
                break;
            }
            case INFO: {
                this.info.increment();
                break;
            }
            case WARN: {
                this.warn.increment();
                break;
            }
            case ERROR: {
                this.error.increment();
                break;
            }
            case FATAL: {
                this.fatal.increment();
                break;
            }
        }
    }
}

