#!/bin/bash

project_name=$1
actualIp=$2
hostname=$2
active=$3
serverPort=$4
javaOption=$5
waitTime=$6
imageName=$7
checkPoint=/actuator/info
deployJarPath=/opt/jenkins/${project_name}.jar

echo "deployJarPath is [$deployJarPath]"
echo "project_name is [$project_name]"
echo "actualIp is [$actualIp]"
echo "hostname is [$hostname]"
echo "active is [$active]"

if [[ -z "$waitTime" ]]; then
  waitTime=20
fi
echo "wait stop time is [$waitTime]"

if [[ -z "$imageName" ]]; then
  imageName="openjdk:8-jdk-alpine"
fi
echo "imageName [$imageName]"

if [[ -z "$javaOption" ]]; then
  javaOption="-Xms512m -Xmx512m"
fi
echo "javaOption [$javaOption]"

echo "[$project_name] will be stop"
docker stop -t ${waitTime} ${project_name}
echo "$project_name has been stopped!"

echo "remove [$project_name]history docker container"
docker rm -f ${project_name}

echo "docker run [$project_name]"
docker run -d --name ${project_name} --net=host --init --add-host=${hostname}:${actualIp} --hostname=${hostname} \
-v /opt/${project_name}/logs:/opt/logs \
-v /opt/${project_name}/temp:/opt/temp \
-v /opt/${project_name}/extend:/opt/extend \
-v ${deployJarPath}:/opt/app.jar \
-v /opt/jenkins/arthas-boot.jar:/opt/arthas-boot.jar \
--privileged=true \
--log-driver json-file \
--log-opt max-size=50m \
--log-opt max-file=3 \
${imageName} \
java -server -XX:HeapDumpPath=/opt/logs/ ${javaOption} \
-XX:+HeapDumpOnOutOfMemoryError \
-XX:+UseG1GC \
-XX:ParallelGCThreads=4 \
-XX:MaxTenuringThreshold=9 \
-XX:+UseFastAccessorMethods \
-XX:+DisableExplicitGC \
-XX:+ScavengeBeforeFullGC \
-XX:SoftRefLRUPolicyMSPerMB=0 \
-XX:+ExplicitGCInvokesConcurrent \
-XX:+UseGCLogFileRotation \
-XX:-OmitStackTraceInFastThrow \
-Xloggc:/opt/logs/gc-%t.log \
-XX:+UseGCLogFileRotation \
-XX:NumberOfGCLogFiles=7 \
-XX:GCLogFileSize=100M \
-Duser.timezone=Asia/Shanghai \
-Dclient.encoding.override=UTF-8 \
-Duser.timezone=GMT+8 \
-Dfile.encoding=UTF-8 \
-Djava.security.egd=file:/dev/./urandom \
-Djava.io.tmpdir=/opt/temp \
-Djava.awt.headless=true \
-Djava.net.preferIPv4Stack=true \
-Dspring.profiles.active=${active} \
-Denv=${active} \
-DexecutorIp=${actualIp} \
-jar /opt/app.jar

# check service status
if [[ ! -z "$serverPort" ]]; then
  check_url="http://${actualIp}:${serverPort}${checkPoint}"
  declare -i counter=0
  declare -i max_counter=60

  until [[ "$(curl -I  -m  10  -o  /dev/null  -s  -w  %{http_code} ${check_url})" == "200" ]];
  do
    if [[ (( counter -ge max_counter)) ]]
    then
      echo "retry max_times, $project_name cannot start"
      exit 1;
    fi

    counter+=1
    echo "$check_url ,retry times $counter "
    sleep 1
  done
  echo "$project_name $actualIp has been started"
fi
