package com.bxm.component.mircometer.config;

import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

import static com.bxm.component.mircometer.utils.TreadPoolMetrics.add;

/**
 * 线程池监控配置
 *
 * @author liujia
 * @date 12/2/21 1:14 PM
 **/
@Configuration
@EnableConfigurationProperties(ComponentMetricsProperties.class)
public class TreadPoolMetricsConfiguration implements ApplicationRunner {

    private ApplicationContext applicationContext;

    private ComponentMetricsProperties properties;

    public TreadPoolMetricsConfiguration(ApplicationContext applicationContext, ComponentMetricsProperties properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        if (properties.isEnableThreadPool()) {
            Map<String, ThreadPoolExecutor> threadPoolExecutorMap = applicationContext.getBeansOfType(ThreadPoolExecutor.class);

            for (Map.Entry<String, ThreadPoolExecutor> executorEntry : threadPoolExecutorMap.entrySet()) {
                add(executorEntry.getKey(), executorEntry.getValue());
            }

            Map<String, ThreadPoolTaskExecutor> taskExecutorMap = applicationContext.getBeansOfType(ThreadPoolTaskExecutor.class);

            for (Map.Entry<String, ThreadPoolTaskExecutor> executorEntry : taskExecutorMap.entrySet()) {
                add(executorEntry.getKey(), executorEntry.getValue().getThreadPoolExecutor());
            }
        }
    }
}
