/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mircometer.utils;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class TreadPoolMetrics {
    private static final Logger log = LoggerFactory.getLogger(TreadPoolMetrics.class);

    private TreadPoolMetrics() {
    }

    public static void add(String poolName, ThreadPoolTaskExecutor taskExecutor) {
        TreadPoolMetrics.add(poolName, taskExecutor.getThreadPoolExecutor());
    }

    public static void add(String poolName, ThreadPoolExecutor executor) {
        BlockingQueue<Runnable> queue;
        if (log.isDebugEnabled()) {
            log.debug("\u521d\u59cb\u5316\u7ebf\u7a0b\u6c60[{}]\u7684\u6307\u6807", (Object)poolName);
        }
        Set<Tag> tags = Collections.singleton(Tag.of((String)"pool.name", (String)poolName));
        Metrics.gauge((String)"thread.pool.core.size", tags, (Object)executor, ThreadPoolExecutor::getCorePoolSize);
        Metrics.gauge((String)"thread.pool.largest.size", tags, (Object)executor, ThreadPoolExecutor::getLargestPoolSize);
        Metrics.gauge((String)"thread.pool.max.size", tags, (Object)executor, ThreadPoolExecutor::getMaximumPoolSize);
        Metrics.gauge((String)"thread.pool.active.size", tags, (Object)executor, ThreadPoolExecutor::getActiveCount);
        Metrics.gauge((String)"thread.pool.current.size", tags, (Object)executor, ThreadPoolExecutor::getPoolSize);
        Metrics.gauge((String)"thread.pool.queue.size", tags, (Object)executor, targetExecutor -> {
            BlockingQueue<Runnable> queue = targetExecutor.getQueue();
            int size = queue.size();
            if (size == Integer.MAX_VALUE) {
                size = -1;
            }
            return size;
        });
        if (log.isDebugEnabled() && null != (queue = executor.getQueue())) {
            log.debug("{}\u4f7f\u7528\u7684\u961f\u5217\u7c7b\u578b\uff1a{}", (Object)poolName, (Object)queue.getClass().getName());
        }
    }
}

