/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mircometer.config;

import com.bxm.component.mircometer.config.ComponentMetricsProperties;
import com.bxm.component.mircometer.utils.TreadPoolMetrics;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableConfigurationProperties(value={ComponentMetricsProperties.class})
public class TreadPoolMetricsConfiguration
implements ApplicationRunner {
    private ApplicationContext applicationContext;
    private ComponentMetricsProperties properties;

    public TreadPoolMetricsConfiguration(ApplicationContext applicationContext, ComponentMetricsProperties properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    public void run(ApplicationArguments args) throws Exception {
        if (this.properties.isEnableThreadPool()) {
            Map threadPoolExecutorMap = this.applicationContext.getBeansOfType(ThreadPoolExecutor.class);
            for (Map.Entry executorEntry : threadPoolExecutorMap.entrySet()) {
                TreadPoolMetrics.add((String)executorEntry.getKey(), (ThreadPoolExecutor)executorEntry.getValue());
            }
            Map taskExecutorMap = this.applicationContext.getBeansOfType(ThreadPoolTaskExecutor.class);
            for (Map.Entry executorEntry : taskExecutorMap.entrySet()) {
                TreadPoolMetrics.add((String)executorEntry.getKey(), ((ThreadPoolTaskExecutor)executorEntry.getValue()).getThreadPoolExecutor());
            }
        }
    }
}

