/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mybatis.dbshunt.strategy.handle;

import com.bxm.component.mybatis.dbshunt.entity.ShuntTableLog;
import com.bxm.component.mybatis.dbshunt.enums.DBShuntTypeEnum;
import com.bxm.component.mybatis.dbshunt.param.ShuntParam;
import com.bxm.component.mybatis.dbshunt.strategy.handle.AbstractTableHandler;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitTableNameByDayHandle
extends AbstractTableHandler {
    private static final Logger log = LoggerFactory.getLogger(InitTableNameByDayHandle.class);
    @Autowired
    private SequenceCreater sequenceCreater;
    private static final String DATE_DAY_FORMAT = "yyyyMMdd";
    private static ThreadLocal<DateFormat> PATTERN_DAY_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_DAY_FORMAT));

    @Override
    public void tableDataHandler(ShuntParam shuntParam) {
        if (shuntParam.getTypeValue() != null && shuntParam.getTypeValue() <= 0) {
            log.error("\u89c4\u5219\u7c7b\u578b\u4e0d\u80fd<=0\uff0cshuntParam\uff1a{}", (Object)JSON.toJSONString((Object)shuntParam));
            return;
        }
        this.initShuntTableData(shuntParam.getDataName());
        ShuntTableLog shuntTableLog = this.getLastLogByTableNameAndType(shuntParam.getTableName(), shuntParam.getDbShuntTypeEnum());
        shuntTableLog = shuntTableLog == null ? this.insertTableLog(shuntParam) : this.judgeTableLogInfoExpire(shuntTableLog, shuntParam);
        this.finalHandlerData(shuntTableLog, shuntParam);
    }

    private void finalHandlerData(ShuntTableLog shuntTableLog, ShuntParam shuntParam) {
        List<String> tableNameList = this.getTableNameList(shuntParam.getDataName(), shuntParam.getTableName());
        if (tableNameList.isEmpty()) {
            log.error("\u6570\u636e\u5e93\u8868\u4e0d\u5b58\u5728");
            return;
        }
        String newTableName = shuntTableLog.getTableName() + "_" + shuntTableLog.getType() + "_" + shuntTableLog.getSuffix();
        String dateStr = this.getDateStr(shuntParam.getTypeValue());
        this.initNewNameTable(newTableName, shuntParam);
        boolean isHandler = false;
        if (tableNameList.size() > 1) {
            Pattern pattern = Pattern.compile(shuntParam.getTableName() + "_[\\d]{1,}$");
            for (String tableName : tableNameList) {
                Matcher matcher = pattern.matcher(tableName);
                if (!matcher.find()) continue;
                this.insertAndDelData(tableName, newTableName, shuntParam.getConditionField(), dateStr);
                isHandler = true;
            }
        } else {
            this.insertAndDelData(tableNameList.get(0), newTableName, shuntParam.getConditionField(), dateStr);
            isHandler = true;
        }
        if (!isHandler) {
            this.insertAndDelData(tableNameList.get(0), newTableName, shuntParam.getConditionField(), dateStr);
        }
    }

    private String getDateStr(Integer dayNums) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, dayNums * -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date calendarTime = calendar.getTime();
        return DateUtils.formatDateTime((Date)calendarTime);
    }

    private void insertAndDelData(String oldTableName, String newTableName, String conditionField, String dateStr) {
        int existDataByDate;
        while ((existDataByDate = this.dbShuntMapper.isExistDataByDate(oldTableName, conditionField, dateStr)) != 0) {
            this.dbShuntMapper.insertDataToNewTable(newTableName, oldTableName, conditionField, dateStr);
            this.dbShuntMapper.deleteOldTableData(oldTableName, conditionField, dateStr);
        }
    }

    private ShuntTableLog insertTableLog(ShuntParam shuntParam) {
        ShuntTableLog shuntTableLog = new ShuntTableLog();
        shuntTableLog.setSuffix(this.tableSuffixHandler(shuntParam));
        shuntTableLog.setId(this.sequenceCreater.nextLongId());
        shuntTableLog.setCreateTime(new Date());
        shuntTableLog.setTableName(shuntParam.getTableName());
        shuntTableLog.setType(shuntParam.getDbShuntTypeEnum().getType());
        shuntTableLog.setTypeValue(shuntParam.getTypeValue());
        this.dbShuntMapper.insertTableNameLog("t_db_shunt_table_log", shuntTableLog);
        return shuntTableLog;
    }

    private String tableSuffixHandler(ShuntParam shuntParam) {
        Date date = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)(shuntParam.getTypeValue() * -1));
        return PATTERN_DAY_FORMAT.get().format(date);
    }

    private ShuntTableLog judgeTableLogInfoExpire(ShuntTableLog shuntTableLog, ShuntParam shuntParam) {
        if (!Objects.equals(shuntTableLog.getTypeValue(), shuntParam.getTypeValue())) {
            return this.insertTableLog(shuntParam);
        }
        Date insertTime = shuntTableLog.getCreateTime();
        Calendar cal = Calendar.getInstance();
        cal.setTime(insertTime);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date insertDate = cal.getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, shuntParam.getTypeValue() * -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date calendarTime = calendar.getTime();
        if (calendarTime.getTime() >= insertDate.getTime()) {
            return this.insertTableLog(shuntParam);
        }
        return shuntTableLog;
    }

    @Override
    public DBShuntTypeEnum getType() {
        return DBShuntTypeEnum.DAY;
    }
}

