package com.bxm.component.mybatis.dto;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.newidea.component.dto.IPageModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 对mybatis plus中的分页模型进行适配
 *
 * @author liujia
 * @date 6/4/21 11:00 AM
 **/
@ApiModel(description = "分页模型")
public class PlusPageModelDTO<T> implements IPageModel<T> {

    @ApiModelProperty("当前页")
    private int pageNum;

    @ApiModelProperty("每页显示数量")
    private int pageSize;

    @ApiModelProperty("总记录数")
    private long total;

    @ApiModelProperty("总页数")
    private int pages;

    @ApiModelProperty("当前获取的数据条数")
    private int size;

    @ApiModelProperty("分页查询结果集")
    private List<T> list;

    @ApiModelProperty("前一页码号")
    private int prePage;

    @ApiModelProperty("下一页码号")
    private int nextPage;

    @ApiModelProperty("是否为第一页")
    private boolean isFirstPage = false;

    @ApiModelProperty("是否为最后一页")
    private boolean isLastPage = false;

    @ApiModelProperty("是否有前一页")
    private boolean hasPreviousPage = false;

    @ApiModelProperty("是否有下一页")
    private boolean hasNextPage = false;

    @ApiModelProperty("第一页页码")
    private int firstPage;

    @ApiModelProperty("最后一页页码")
    private int lastPage;

    private IPage<T> plusPage;

    private PlusPageModelDTO() {
    }

    private void setPlusPage(IPage<T> plusPage) {
        this.plusPage = plusPage;

        if (null != plusPage) {
            this.list = plusPage.getRecords();

            this.pageNum = (int) plusPage.getCurrent();
            this.pageSize = (int) plusPage.getSize();
            this.total = plusPage.getTotal();
            this.pages = (int) plusPage.getPages();
            this.size = list.size();

            this.prePage = pageNum <= 1 ? 1 : pageNum - 1;
            this.nextPage = pageNum >= pages ? pages : pageNum + 1;
            this.isFirstPage = pageNum == 1;
            this.isLastPage = pageNum == pages;
            this.hasPreviousPage = pageNum != 1;
            this.hasNextPage = pageNum != pages;
            this.firstPage = 1;
            this.lastPage = pages;
        }
    }

    /**
     * 将mybatis-plus中的分页模型适配为历史的分页模型
     *
     * @param plusPage mybatis-plus分页模型
     * @param <T>      分页数据类型
     * @return 新的分页模型
     */
    public static <T> PlusPageModelDTO<T> build(IPage<T> plusPage) {
        PlusPageModelDTO<T> model = new PlusPageModelDTO<>();
        model.setPlusPage(plusPage);
        return model;
    }

    /**
     * 复制原有的分页参数，然后创建一个新的分页模型
     * 变更一个新的分页模型，当查询的分页对象和最终返回的分页对象不一致时使用
     *
     * @param list 新的分页对象集合
     * @param <M>  新的对象类型
     * @return 新的模型对象
     */
    public <M> PlusPageModelDTO<M> changeList(List<M> list) {
        PlusPageModelDTO<M> model = new PlusPageModelDTO<>();
        model.pages = this.pages;
        model.pageNum = this.pageNum;
        model.total = this.total;
        model.size = this.size;
        model.prePage = this.prePage;
        model.nextPage = this.nextPage;
        model.isFirstPage = this.isFirstPage;
        model.isLastPage = this.isLastPage;
        model.hasPreviousPage = this.hasPreviousPage;
        model.hasNextPage = this.hasNextPage;
        model.firstPage = this.firstPage;
        model.lastPage = this.lastPage;

        model.list = list;
        return model;
    }

    @Override
    public int getPageNum() {
        return this.pageNum;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public int getPages() {
        return this.pages;
    }

    @Override
    public List<T> getList() {
        return this.list;
    }

    @Override
    public int getPrePage() {
        return this.prePage;
    }

    @Override
    public int getNextPage() {
        return this.nextPage;
    }

    @Override
    public boolean isFirstPage() {
        return this.isFirstPage;
    }

    @Override
    public boolean isLastPage() {
        return this.isLastPage;
    }

    @Override
    public boolean isHasPreviousPage() {
        return this.hasPreviousPage;
    }

    @Override
    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    @Override
    public int getFirstPage() {
        return this.firstPage;
    }

    @Override
    public int getLastPage() {
        return this.lastPage;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public void setFirstPage(boolean firstPage) {
        this.isFirstPage = firstPage;
    }

    public void setLastPage(boolean lastPage) {
        this.isLastPage = lastPage;
    }

    public void setHasPreviousPage(boolean hasPreviousPage) {
        this.hasPreviousPage = hasPreviousPage;
    }

    public void setHasNextPage(boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    public void setFirstPage(int firstPage) {
        this.firstPage = firstPage;
    }

    public void setLastPage(int lastPage) {
        this.lastPage = lastPage;
    }

    @Override
    public String toString() {
        return "PlusPageModelDTO(pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", total=" + this.getTotal() + ", pages=" + this.getPages() + ", size=" + this.getSize() + ", list=" + this.getList() + ", prePage=" + this.getPrePage() + ", nextPage=" + this.getNextPage() + ", isFirstPage=" + this.getFirstPage() + ", isLastPage=" + this.getLastPage() + ", hasPreviousPage=" + this.isHasPreviousPage() + ", hasNextPage=" + this.isHasNextPage() + ", firstPage=" + this.getFirstPage() + ", lastPage=" + this.getLastPage() + ", plusPage=" + this.plusPage + ")";
    }
}
