/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mybatis.dbshunt.strategy.handle;

import com.bxm.component.mybatis.dbshunt.entity.ShuntTableLog;
import com.bxm.component.mybatis.dbshunt.enums.DBShuntTypeEnum;
import com.bxm.component.mybatis.dbshunt.param.ShuntParam;
import com.bxm.component.mybatis.dbshunt.strategy.handle.AbstractTableHandler;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitTableNameByMonthHandle
extends AbstractTableHandler {
    private static final Logger log = LoggerFactory.getLogger(InitTableNameByMonthHandle.class);
    @Autowired
    private SequenceCreater sequenceCreater;
    private static final String DATE_MONTH_FORMAT = "yyyyMM";
    private static ThreadLocal<DateFormat> PATTERN_MONTH_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_MONTH_FORMAT));

    @Override
    public void tableDataHandler(ShuntParam shuntParam) {
        this.initShuntTableData(shuntParam.getDataName());
        ShuntTableLog shuntTableLog = this.getLastLogByTableNameAndType(shuntParam.getTableName(), shuntParam.getDbShuntTypeEnum());
        shuntTableLog = shuntTableLog == null ? this.insertTableLog(shuntParam) : this.judgeTableLogInfoExpire(shuntTableLog, shuntParam);
        this.finalHandlerData(shuntTableLog, shuntParam);
    }

    private void finalHandlerData(ShuntTableLog shuntTableLog, ShuntParam shuntParam) {
        List<String> tableNameList = this.getTableNameList(shuntParam.getDataName(), shuntParam.getTableName());
        if (tableNameList.isEmpty()) {
            log.error("\u6570\u636e\u5e93\u8868\u4e0d\u5b58\u5728");
            return;
        }
        String newTableName = shuntTableLog.getTableName() + "_" + shuntTableLog.getType() + "_" + shuntTableLog.getSuffix();
        String dateStr = this.getDateStr();
        this.initNewNameTable(newTableName, shuntParam);
        boolean isHandler = false;
        if (tableNameList.size() > 1) {
            Pattern pattern = Pattern.compile(shuntParam.getTableName() + "_[\\d]{1,}$");
            for (String tableName : tableNameList) {
                Matcher matcher = pattern.matcher(tableName);
                if (!matcher.find()) continue;
                this.insertAndDelData(tableName, newTableName, shuntParam.getConditionField(), dateStr);
                isHandler = true;
            }
        } else {
            this.insertAndDelData(tableNameList.get(0), newTableName, shuntParam.getConditionField(), dateStr);
            isHandler = true;
        }
        if (!isHandler) {
            this.insertAndDelData(tableNameList.get(0), newTableName, shuntParam.getConditionField(), dateStr);
        }
    }

    private String getDateStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date calendarTime = calendar.getTime();
        Date date = org.apache.commons.lang3.time.DateUtils.addSeconds((Date)calendarTime, (int)-1);
        return DateUtils.formatDateTime((Date)date);
    }

    private void insertAndDelData(String oldTableName, String newTableName, String conditionField, String dateStr) {
        int existDataByDate;
        while ((existDataByDate = this.dbShuntMapper.isExistDataByDate(oldTableName, conditionField, dateStr)) != 0) {
            this.dbShuntMapper.insertDataToNewTable(newTableName, oldTableName, conditionField, dateStr);
            this.dbShuntMapper.deleteOldTableData(oldTableName, conditionField, dateStr);
        }
    }

    private ShuntTableLog insertTableLog(ShuntParam shuntParam) {
        ShuntTableLog shuntTableLog = new ShuntTableLog();
        shuntTableLog.setId(this.sequenceCreater.nextLongId());
        shuntTableLog.setSuffix(this.tableSuffixHandler());
        shuntTableLog.setCreateTime(new Date());
        shuntTableLog.setTableName(shuntParam.getTableName());
        shuntTableLog.setType(shuntParam.getDbShuntTypeEnum().getType());
        shuntTableLog.setTypeValue(shuntParam.getTypeValue());
        this.dbShuntMapper.insertTableNameLog("t_db_shunt_table_log", shuntTableLog);
        return shuntTableLog;
    }

    private String tableSuffixHandler() {
        Date date = org.apache.commons.lang3.time.DateUtils.addMonths((Date)new Date(), (int)-1);
        return PATTERN_MONTH_FORMAT.get().format(date);
    }

    private ShuntTableLog judgeTableLogInfoExpire(ShuntTableLog shuntTableLog, ShuntParam shuntParam) {
        Date suffixDate;
        try {
            suffixDate = PATTERN_MONTH_FORMAT.get().parse(shuntTableLog.getSuffix());
        }
        catch (ParseException e) {
            log.error("\u89e3\u6790\u65f6\u95f4\u5931\u8d25\uff0c\u76f4\u63a5\u8d70\u63d2\u5165\u903b\u8f91");
            return this.insertTableLog(shuntParam);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(org.apache.commons.lang3.time.DateUtils.addMonths((Date)new Date(), (int)-1));
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date calendarDate = calendar.getTime();
        boolean sameDay = org.apache.commons.lang3.time.DateUtils.isSameDay((Date)suffixDate, (Date)calendarDate);
        if (!sameDay) {
            return this.insertTableLog(shuntParam);
        }
        return shuntTableLog;
    }

    @Override
    public DBShuntTypeEnum getType() {
        return DBShuntTypeEnum.MONTH;
    }
}

