package com.bxm.newidea.component.vo;


import com.bxm.newidea.component.dto.IPageModel;
import com.github.pagehelper.Page;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Collection;
import java.util.List;

/**
 * 兼容万事通中历史的
 *
 * @author liujia
 * @date 7/29/21 2:14 PM
 **/
@ApiModel(description = "分页模型")
public class PageWarper<T> implements IPageModel<T> {

    public PageWarper() {
    }

    public PageWarper(List<T> list) {
        this.list = list;

        if (list instanceof Page) {
            Page page = (Page) list;
            this.pageNum = page.getPageNum();
            this.pageSize = page.getPageNum();
            this.total = page.getTotal();
            this.pages = page.getPages();
            this.size = list.size();

        } else if (list instanceof Collection) {
            this.pageNum = 1;
            this.pageSize = list.size();
            this.total = list.size();
            this.pages = this.pageSize > 0 ? 1 : 0;
            this.size = list.size();
        }

        this.prePage = pageNum <= 1 ? 1 : pageNum - 1;
        this.nextPage = pageNum >= pages ? pages : pageNum + 1;
        this.isFirstPage = pageNum == 1;
        this.isLastPage = pageNum == pages;
        this.hasPreviousPage = pageNum != 1;
        this.hasNextPage = pageNum != pages;
        this.firstPage = 1;
        this.lastPage = pages;
    }

    /**
     * 手动设置集合数据
     *
     * @param list
     */
    public void setList(List<T> list) {
        this.list = list;
    }

    /**
     * 将当前的模型数据转变为另外一个类型，需要原有分页的相关信息，但是返回模型不是数据库查询的类型时，使用此方法
     *
     * @param list 返回的数据
     * @return 新的数据模型
     */
    public <M> PageWarper<M> changeList(List<M> list) {
        PageWarper<M> model = new PageWarper<>();
        model.pages = this.pages;
        model.pageNum = this.pageNum;
        model.total = this.total;
        model.size = this.size;
        model.prePage = this.prePage;
        model.nextPage = this.nextPage;
        model.isFirstPage = this.isFirstPage;
        model.isLastPage = this.isLastPage;
        model.hasPreviousPage = this.hasPreviousPage;
        model.hasNextPage = this.hasNextPage;
        model.firstPage = this.firstPage;
        model.lastPage = this.lastPage;

        model.list = list;
        return model;
    }

    @ApiModelProperty("当前页")
    private int pageNum;

    @ApiModelProperty("每页显示数量")
    private int pageSize;

    @ApiModelProperty("总记录数")
    private long total;

    @ApiModelProperty("总页数")
    private int pages;

    @ApiModelProperty("当前获取的数据条数")
    private int size;

    @ApiModelProperty("分页查询结果集")
    private List<T> list;

    @ApiModelProperty("前一页码号")
    private int prePage;

    @ApiModelProperty("下一页码号")
    private int nextPage;

    @ApiModelProperty("是否为第一页")
    private boolean isFirstPage = false;

    @ApiModelProperty("是否为最后一页")
    private boolean isLastPage = false;

    @ApiModelProperty("是否有前一页")
    private boolean hasPreviousPage = false;

    @ApiModelProperty("是否有下一页")
    private boolean hasNextPage = false;

    @ApiModelProperty("第一页页码")
    private int firstPage;

    @ApiModelProperty("最后一页页码")
    private int lastPage;

    @Override
    public int getPageNum() {
        return this.pageNum;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public int getPages() {
        return this.pages;
    }

    @Override
    public List<T> getList() {
        return this.list;
    }

    @Override
    public int getPrePage() {
        return this.prePage;
    }

    @Override
    public int getNextPage() {
        return this.nextPage;
    }

    @Override
    public boolean isFirstPage() {
        return this.isFirstPage;
    }

    @Override
    public boolean isLastPage() {
        return this.isLastPage;
    }

    @Override
    public boolean isHasPreviousPage() {
        return this.hasPreviousPage;
    }

    @Override
    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    @Override
    public int getFirstPage() {
        return this.firstPage;
    }

    @Override
    public int getLastPage() {
        return this.lastPage;
    }
}
