package com.bxm.component.httpclient.config;

import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * httpclient客户端配置
 */
@Configuration
@ConditionalOnMissingBean(HttpClientConnectionManager.class)
public class HttpClientConfiguration {

    /**
     * 使用httpclient连接池管理器
     */
    private HttpClientConnectionManager httpClientConnectionManager() {
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
        //连接池最大连接数
        poolingHttpClientConnectionManager.setMaxTotal(200);
        //设置每个主机地址的最大并发数
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(50);
        return poolingHttpClientConnectionManager;
    }

    /**
     * 配置连接参数
     */
    @Bean
    @ConditionalOnMissingBean(RequestConfig.class)
    public RequestConfig requestConfig() {
        //连接配置
        return RequestConfig.custom()
                //创建连接的最长时间
                .setConnectTimeout(1000)
                //从连接池中获取到连接的最长时间
                .setConnectionRequestTimeout(500)
                //数据传输的最长时间
                .setSocketTimeout(10000)
                .build();
    }

    /**
     * 注册httpClient客户端
     */
    @Bean
    @ConditionalOnMissingBean(CloseableHttpClient.class)
    public CloseableHttpClient httpClient() {
        //配置httpclientBuilder
        HttpClientBuilder httpClientBuilder = HttpClients.custom()
                //设置连接池
                .setConnectionManager(httpClientConnectionManager())
                //设置连接的参数
                .setDefaultRequestConfig(requestConfig());
        return httpClientBuilder.build();
    }

}
