/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.httpclient.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;

public enum NetworkInterfaceManager {
    INSTANCE;

    private InetAddress m_local;
    private InetAddress m_localHost;

    private NetworkInterfaceManager() {
        this.load();
    }

    public InetAddress findValidateIp(List<InetAddress> addresses) {
        InetAddress local = null;
        int maxWeight = -1;
        for (InetAddress address : addresses) {
            if (!(address instanceof Inet4Address)) continue;
            int weight = 0;
            if (address.isSiteLocalAddress()) {
                weight += 8;
            }
            if (address.isLinkLocalAddress()) {
                weight += 4;
            }
            if (address.isLoopbackAddress()) {
                weight += 2;
            }
            if (!Objects.equals(address.getHostName(), address.getHostAddress())) {
                ++weight;
            }
            if (weight <= maxWeight) continue;
            maxWeight = weight;
            local = address;
        }
        return local;
    }

    public String getLocalHostAddress() {
        return this.m_local.getHostAddress();
    }

    public String getLocalHostName() {
        try {
            if (null == this.m_localHost) {
                this.m_localHost = InetAddress.getLocalHost();
            }
            return this.m_localHost.getHostName();
        }
        catch (UnknownHostException e) {
            return this.m_local.getHostName();
        }
    }

    private String getProperty(String name) {
        String value = null;
        value = System.getProperty(name);
        if (value == null) {
            value = System.getenv(name);
        }
        return value;
    }

    private void load() {
        String ip = this.getProperty("host.ip");
        if (ip != null) {
            try {
                this.m_local = InetAddress.getByName(ip);
                return;
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            List<NetworkInterface> nis = interfaces == null ? Collections.emptyList() : Collections.list(interfaces);
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            InetAddress local = null;
            try {
                for (NetworkInterface ni : nis) {
                    if (!ni.isUp() || ni.isLoopback()) continue;
                    addresses.addAll(Collections.list(ni.getInetAddresses()));
                }
                local = this.findValidateIp(addresses);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (local != null) {
                this.m_local = local;
                return;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.m_local = InetAddress.getLoopbackAddress();
    }
}

