package com.bxm.component.httpclient.service;

import java.util.Map;

/**
 * httpclient服务接口，基于连接池进行连接处理
 *
 * @deprecated 实现过重，不再推荐调用。可使用{@link com.bxm.component.httpclient.utils.OkHttpUtils}代替
 */
public interface HttpClientService {

    /**
     * 发送GET请求
     *
     * @param url 请求地址
     * @return 请求成功后返回的字符串
     */
    String doGet(String url);

    /**
     * 发送带有参数的GET请求
     *
     * @param url    请求地址
     * @param params 请求参数
     * @return 请求成功后返回的字符串
     */
    String doGet(String url, Map<String, String> params);

    /**
     * 发送带有参数的POST请求
     *
     * @param url    请求地址
     * @param params 请求参数
     * @return 请求成功后返回的字符串
     */
    String doPost(String url, Map<String, String> params);

    /**
     * 通过post发送字符串
     *
     * @param url     请求地址
     * @param content 请求内容
     * @return 请求成功后的返回结果
     */
    String doPost(String url, String content);

    /**
     * 发送json数据POST请求
     *
     * @param url  请求地址
     * @param json 请求参数
     * @return 请求成功后返回的字符串
     */
    String doPostJson(String url, String json);

}
