/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.notify.channel;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.notify.channel.IChannel;
import com.bxm.newidea.component.notify.enums.NotifyMessageInterceptorTypeEnum;
import com.bxm.newidea.component.notify.interceptor.INotifyMessageInterceptor;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.rule.RuleExecutor;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelAgent {
    private static final Logger log = LoggerFactory.getLogger(ChannelAgent.class);
    private RuleExecutor ruleExecutor;
    private List<INotifyMessageInterceptor> berforInterceptors;
    private List<INotifyMessageInterceptor> afterInterceptors;

    public ChannelAgent(RuleExecutor ruleExecutor, List<INotifyMessageInterceptor> iNotifyMessageInterceptors) {
        this.ruleExecutor = ruleExecutor;
        if (iNotifyMessageInterceptors != null && iNotifyMessageInterceptors.size() > 0) {
            this.berforInterceptors = Lists.newArrayList((Iterable)iNotifyMessageInterceptors.stream().filter(messageInterceptor -> NotifyMessageInterceptorTypeEnum.BEFORE.equals((Object)messageInterceptor.interceptorType())).collect(Collectors.toList()));
            this.afterInterceptors = Lists.newArrayList((Iterable)iNotifyMessageInterceptors.stream().filter(messageInterceptor -> NotifyMessageInterceptorTypeEnum.AFTER.equals((Object)messageInterceptor.interceptorType())).collect(Collectors.toList()));
        }
    }

    public <T extends NotifyMessage> void publish(IChannel channel, T message) {
        HashSet executeRules = Sets.newHashSet();
        if (this.berforInterceptors != null && this.berforInterceptors.size() > 0) {
            for (INotifyMessageInterceptor interceptor : this.berforInterceptors) {
                interceptor.invoke(message);
            }
        }
        if (null != message.getRuleList()) {
            executeRules.addAll(message.getRuleList());
        }
        if (null != channel.bindRules()) {
            executeRules.addAll(channel.bindRules());
        }
        for (Class ruleClass : executeRules) {
            boolean accept = this.ruleExecutor.accept(ruleClass, message);
            if (accept) continue;
            log.info("{}\u89c4\u5219\u6267\u884c\u5931\u8d25\uff0c\u6d88\u606f{}\u4e0d\u4e88\u53d1\u9001", (Object)ruleClass, (Object)JSON.toJSONString(message));
            return;
        }
        channel.publish(message);
        if (this.afterInterceptors != null && this.afterInterceptors.size() > 0) {
            for (INotifyMessageInterceptor interceptor : this.afterInterceptors) {
                interceptor.invoke(message);
            }
        }
    }
}

