package com.bxm.newidea.component.notify.assembly;

import com.bxm.newidea.component.notify.assembly.dingding.DingdingCardMessageAssembler;
import com.bxm.newidea.component.notify.assembly.dingding.DingdingMarkdownMessageAssembler;
import com.bxm.newidea.component.notify.assembly.dingding.DingdingTextMessageAssembler;
import com.bxm.newidea.component.notify.assembly.email.EmailHtmlMessageAssembler;
import com.bxm.newidea.component.notify.assembly.email.EmailTextMessageAssembler;
import com.bxm.newidea.component.notify.assembly.wechat.WechatCardMessageAssembler;
import com.bxm.newidea.component.notify.assembly.wechat.WechatMarkdownMessageAssembler;
import com.bxm.newidea.component.notify.assembly.wechat.WechatTextMessageAssembler;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.tools.ReflectionUtils;
import com.google.common.collect.HashBasedTable;
import lombok.extern.slf4j.Slf4j;

/**
 * @author liujia
 * @date 11/26/21 10:38 AM
 **/
@Slf4j
public class MessageAssembler {

    private static HashBasedTable<String, Class<?>, IMessageAssembler> registerAssemblerTable = HashBasedTable.create();

    static {
        register(new DingdingTextMessageAssembler());
        register(new DingdingCardMessageAssembler());
        register(new DingdingMarkdownMessageAssembler());
        register(new WechatTextMessageAssembler());
        register(new WechatCardMessageAssembler());
        register(new WechatMarkdownMessageAssembler());
        register(new EmailTextMessageAssembler());
        register(new EmailHtmlMessageAssembler());
    }

    /**
     * 注册消息组装
     *
     * @param assembler 消息组装类
     */
    public static void register(IMessageAssembler assembler) {
        Class<Object> firstGenericType = ReflectionUtils.getFirstGenericType(assembler.getClass());
        if (null == firstGenericType) {
            log.error("{}找不到支持的消息类型", assembler);
            return;
        }
        registerAssemblerTable.put(assembler.platform(), firstGenericType, assembler);
    }

    public static <M extends NotifyMessage, R> R assembly(String platform, M message) {
        IMessageAssembler assembler = registerAssemblerTable.get(platform, message.getClass());
        if (null == assembler) {
            log.info("消息类型[{}]和平台[{}]没有对应的处理类，直接返回", message.getClass(), platform);
            return null;
        }

        return (R) assembler.assembler(message);
    }
}
