package com.bxm.newidea.component.notify.assembly.dingding.model;

import lombok.Data;

import java.util.List;

/**
 * 钉钉card格式参数
 * <p>
 * {
 * "msgtype":"feedCard",
 * "feedCard": {
 * "links": [
 * {
 * "getTitle": "时代的火车向前开1",
 * "messageURL": "https://www.dingtalk.com/",
 * "picURL": "https://img.alicdn.com/tfs/TB1NwmBEL9TBuNjy1zbXXXpepXa-2400-1218.png"
 * }
 * ]
 * }
 * }
 *
 * @author JIY
 * @date 2021/11/24 18:56
 */
@Data
public class DingDingCardDTO {
    private String msgtype = "feedCard";

    private FeedCardSub feedCard;

    @Data
    public static class FeedCardSub {
        public List<Links> links;
    }

    @Data
    public static class Links {
        public String title;

        public String messageURL;

        public String picURL;

        public Links(String title, String messageURL, String picURL) {
            this.title = title;
            this.messageURL = messageURL;
            this.picURL = picURL;
        }
    }
}
