package com.bxm.newidea.component.notify.assembly.email;

import com.bxm.newidea.component.notify.assembly.IMessageAssembler;
import com.bxm.newidea.component.notify.assembly.email.model.EmailDTO;
import com.bxm.newidea.component.notify.constant.NotifyMessageConstant;
import com.bxm.newidea.component.notify.message.HtmlNotifyMessage;
import com.google.common.collect.Lists;

/**
 * 邮件html格式消息组装
 *
 * @author JIY
 * @date 2021/11/30 8:50 上午
 */
public class EmailHtmlMessageAssembler implements IMessageAssembler<HtmlNotifyMessage, EmailDTO> {

    @Override
    public String platform() {
        return NotifyMessageConstant.Platform.EMAIL;
    }

    @Override
    public EmailDTO assembler(HtmlNotifyMessage message) {
        return new EmailDTO(Lists.newArrayList(message.getMainReceiver()),
                message.getSubReceiver(),message.getTitle(),message.getContent(),true,null);
    }
}
