package com.bxm.newidea.component.notify.channel;

import com.bxm.newidea.component.notify.constant.NotifyMessageConstant;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.rule.IRule;

import java.util.Set;

/**
 * 消息处理的通道，标明消息最终要发往何处
 *
 * @author liujia
 * @date 11/25/21 9:03 PM
 **/
public interface IChannel {

    /**
     * 推送消息
     *
     * @param message 消息内容
     */
    <T extends NotifyMessage> boolean publish(T message);

    /**
     * 当前渠道绑定的处理规则
     *
     * @return 处理规则列表
     */
    Set<Class<? extends IRule>> bindRules();

    /**
     * 渠道唯一编码
     *
     * @return 判断和区分渠道的标识
     */
    String uniqueKey();

    /**
     * 支持的平台
     * 可以参考：{@link NotifyMessageConstant.Platform},也可以自己定义
     *
     * @return 平台定义
     */
    String platform();
}
