package com.bxm.newidea.component.notify.channel.dingding;

import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.notify.assembly.MessageAssembler;
import com.bxm.newidea.component.notify.channel.IChannel;
import com.bxm.newidea.component.notify.channel.model.PublishResponse;
import com.bxm.newidea.component.notify.constant.NotifyMessageConstant;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.rule.IRule;
import com.bxm.newidea.component.notify.rule.impl.DingdingLimitRule;
import com.google.common.collect.ImmutableSet;
import lombok.extern.slf4j.Slf4j;

import java.util.Set;

/**
 * 钉钉的消息推送
 * 使用原型模式返回bean
 *
 * @author liujia
 * @date 11/25/21 10:19 PM
 **/
@Slf4j
public class DingdingChannel implements IChannel {

    private String webHook;

    public String getWebHook() {
        return webHook;
    }

    public void setWebHook(String webHook) {
        this.webHook = webHook;
    }

    @Override
    public <T extends NotifyMessage> boolean publish(T message) {
        String messageBody = MessageAssembler.assembly(this.platform(), message);

        if (log.isDebugEnabled()) {
            log.debug("开始发送钉钉消息:{}", messageBody);
        }

        String response = HttpUtil.post(getWebHook(), messageBody);

        PublishResponse responseObj = JSON.parseObject(response, PublishResponse.class);

        if (log.isDebugEnabled()) {
            log.debug("钉钉推送消息返回结果:{}", responseObj);
        }

        if (responseObj == null || responseObj.getErrcode() != 0) {
            log.info("钉钉消息发送失败，返回内容：{},消息主体：{}", responseObj, messageBody);
            return false;
        }

        return true;
    }

    @Override
    public Set<Class<? extends IRule>> bindRules() {
        return ImmutableSet.of(DingdingLimitRule.class);
    }

    @Override
    public String uniqueKey() {
        return getWebHook();
    }

    @Override
    public String platform() {
        return NotifyMessageConstant.Platform.DINGDING;
    }
}
