package com.bxm.newidea.component.notify.message;

import com.bxm.newidea.component.notify.channel.IChannel;
import com.bxm.newidea.component.notify.enums.NotifyMessageTypeEnum;
import com.bxm.newidea.component.notify.rule.IRule;

import java.util.List;
import java.util.Map;

/**
 * 通知消息，可用于钉钉通知、微信通知、邮件通知等情况
 *
 * @author liujia
 * @date 11/25/21 8:57 PM
 **/
public interface NotifyMessage {

    /**
     * 设置消息的标题
     *
     * @return 通知消息的标题部分
     */
    String getTitle();

    /**
     * 设置消息的内容
     *
     * @return 通知消息的主体内容
     */
    String getContent();

    /**
     * 设置消息类型
     *
     * @return 消息内容类型，参见：{@link NotifyMessageTypeEnum}
     */
    NotifyMessageTypeEnum getMessageType();

    /**
     * 设置消息的主要接受者
     *
     * @return 消息的主送人，谁对消息需要额外关注
     */
    String getMainReceiver();

    /**
     * 可能关注消息的相关人员，类似邮件的抄送
     *
     * @return 消息关注人员
     */
    List<String> getSubReceiver();

    /**
     * 消息需要推送的目标通道
     * 支持配置多个，也可以自定义后续处理
     *
     * @return 消息的发送通道，可以配置多个
     */
    List<IChannel> getChannelList();

    /**
     * 处理规则，判断消息是否可以发送
     *
     * @return 消息过滤规则，防止不符合规则的消息发送出去
     */
    List<Class<? extends IRule>> getRuleList();

    /**
     * 获取额外的扩展参数
     *
     * @return 扩展参数Map
     */
    Map<String, String> getExtendMap();
}
