package com.bxm.newidea.component.notify.assembly.dingding.model;

import com.bxm.newidea.component.notify.message.MarkdownNotifyMessage;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.Data;

import java.util.List;

/**
 * markdown模板
 * @author JIY
 * @date 2021/11/29 2:03 下午
 */
@Data
public class MarkdownSubTemplate {
    public static String get(MarkdownNotifyMessage message){
        StringBuilder sb = new StringBuilder();
        MarkdownNotifyMessage.SubMarkdownContent subMarkdownContent = message.getSubMarkdownContent();
        String applicationName = subMarkdownContent.getApplicationName();
        if(StringUtils.isNoneBlank(applicationName)){
            sb.append("#### ");
            sb.append("【");
            sb.append(applicationName);
            sb.append("】\n");
        }
        String triggerRule = subMarkdownContent.getTriggerRule();
        String triggerRuleUrl = subMarkdownContent.getTriggerRuleUrl();
        if(StringUtils.isNoneBlank(triggerRule) && StringUtils.isNoneBlank(triggerRuleUrl)){
            sb.append("触发规则: ");
            sb.append("[");
            sb.append(triggerRule);
            sb.append("]");
            sb.append("(");
            sb.append(triggerRuleUrl);
            sb.append(") \n");
        }
        List<String> quoteContents = subMarkdownContent.getQuoteContent();
        if(quoteContents != null && quoteContents.size() > 0){
            for (String quoteContent:quoteContents) {
                sb.append("\n>");
                sb.append(quoteContent);
                sb.append("\n");
            }
        }
        String remark = subMarkdownContent.getRemark();
        if(StringUtils.isNoneBlank(remark)){
            sb.append("\n"+remark);
        }
        return sb.toString();
    }
}
