/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.notify.assembly.wechat;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.notify.assembly.IMessageAssembler;
import com.bxm.newidea.component.notify.assembly.wechat.model.WechatTextDTO;
import com.bxm.newidea.component.notify.message.TextNotifyMessage;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class WechatTextMessageAssembler
implements IMessageAssembler<TextNotifyMessage, String> {
    @Override
    public String platform() {
        return "wechat";
    }

    @Override
    public String assembler(TextNotifyMessage message) {
        String atAll;
        WechatTextDTO.TextSub textSub = new WechatTextDTO.TextSub();
        textSub.setContent(message.getContent());
        boolean hitAtAll = false;
        if (message.getExtendMap() != null && null != (atAll = message.getExtendMap().get("@all"))) {
            textSub.setMentioned_mobile_list(new String[]{"@all"});
            hitAtAll = true;
        }
        if (!hitAtAll) {
            ArrayList atMobileList = Lists.newArrayList();
            if (null != message.getMainReceiver()) {
                atMobileList.add(message.getMainReceiver());
            }
            if (null != message.getSubReceiver()) {
                atMobileList.addAll(message.getSubReceiver());
            }
            textSub.setMentioned_mobile_list(atMobileList.toArray(new String[0]));
        }
        WechatTextDTO wechatTextDTO = new WechatTextDTO();
        wechatTextDTO.setText(textSub);
        return JSON.toJSONString((Object)wechatTextDTO);
    }
}

