/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.notify.rule;

import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.rule.IRule;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleExecutor {
    private static final Logger log = LoggerFactory.getLogger(RuleExecutor.class);
    private Map<Class<? extends IRule>, IRule> ruleMap = Maps.newHashMap();

    public RuleExecutor(List<IRule> ruleList) {
        for (IRule iRule : ruleList) {
            this.ruleMap.put(iRule.getClass(), iRule);
        }
    }

    public boolean accept(Class<? extends IRule> ruleClass, NotifyMessage message) {
        IRule iRule = this.ruleMap.get(ruleClass);
        if (iRule == null) {
            log.error("\u5b9a\u4e49\u7684\u89c4\u5219[{}]\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u6ce8\u518c\u5230spring\u4e0a\u4e0b\u6587", ruleClass);
            return false;
        }
        return iRule.accept(message);
    }
}

