package com.bxm.component.oncejob.counter;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * 任务执行汇总类，统计任务执行情况
 *
 * @author liujia
 * @date 8/13/21 3:07PM
 **/
public class JobCounter {

    private JobCounter() {
    }

    /**
     * 当前实例创建的任务数量
     */
    private static AtomicInteger addCount = new AtomicInteger();

    /**
     * 在内存中等待执行的任务数量
     */
    private static AtomicInteger queueCount = new AtomicInteger();

    /**
     * 执行失败的任务数量
     */
    private static AtomicInteger failedCount = new AtomicInteger();

    /**
     * 执行成功的任务数量
     */
    private static AtomicInteger successCount = new AtomicInteger();

    /**
     * 执行中的任务数量
     */
    private static AtomicInteger runningCount = new AtomicInteger();

    /**
     * 过期的任务总数
     */
    private static AtomicInteger expiredCount = new AtomicInteger();

    public static void addCreateCount() {
        addCount.incrementAndGet();
    }

    public static void addQueueCount() {
        queueCount.incrementAndGet();
    }

    public static void consumeQueueCount(int num) {
        queueCount.addAndGet(-num);
    }

    public static void addRunningCount() {
        runningCount.incrementAndGet();
    }

    public static void removeRunningCount() {
        runningCount.decrementAndGet();
    }

    public static int getRunningCount() {
        return runningCount.get();
    }

    public static void addSuccessCount() {
        successCount.incrementAndGet();
    }

    public static void addFailedCount() {
        failedCount.incrementAndGet();
    }

    public static void addExpiredCount() {
        expiredCount.incrementAndGet();
    }

    public static String state() {
        return "队列中的任务：" + queueCount.get() + "," +
                "处理中的任务：" + runningCount.get() + "," +

                "创建任务数量：" + addCount.get() + "," +
                "过期任务数量：" + expiredCount.get() + "," +
                "处理成功总数：" + successCount.get() + "," +
                "处理失败总数：" + failedCount.get();
    }
}
