package com.bxm.component.oncejob.job;

import com.bxm.component.oncejob.enums.MissFireStrategy;
import lombok.Getter;
import lombok.ToString;

import java.util.Date;

/**
 * 一次性定时任务定义
 *
 * @author liujia
 * @date 7/29/21 5:16 PM
 **/
@Getter
@ToString
public class OnceJobDefinition<T> {

    /**
     * 错过执行时间后的处理流程
     */
    private MissFireStrategy missFire;

    /**
     * 处理参数
     */
    private T param;

    /**
     * 执行时间（最终执行时间只会精确到秒）
     */
    private Date fireDate;

    /**
     * 真正的业务逻辑处理对象，必须是一个spring bean
     */
    private IOnceJobCallback<T> callback;

    private OnceJobDefinition() {
    }

    public static OnceJobBuilder builder(Date fireDate) {
        OnceJobBuilder builder = new OnceJobBuilder();
        builder.fireDate(fireDate);

        return builder;
    }

    public static OnceJobBuilder builder() {
        return new OnceJobBuilder();
    }

    public static class OnceJobBuilder {

        private MissFireStrategy missFire;

        private Date fireDate;

        private OnceJobBuilder() {
            this.missFire = MissFireStrategy.REMAIN;
        }

        public OnceJobBuilder missFire(MissFireStrategy missFire) {
            this.missFire = missFire;
            return this;
        }

        public OnceJobBuilder fireDate(Date fireDate) {
            this.fireDate = fireDate;
            return this;
        }

        public <T> OnceJobDefinition<T> build(IOnceJobCallback<T> callback, T param) {
            OnceJobDefinition<T> onceJobDefinition = new OnceJobDefinition<>();
            onceJobDefinition.missFire = this.missFire;
            onceJobDefinition.fireDate = this.fireDate;
            onceJobDefinition.callback = callback;
            onceJobDefinition.param = param;
            return onceJobDefinition;
        }

        public <T> OnceJobDefinition<T> build(IOnceJobCallback<T> callback) {
            return build(callback, null);
        }
    }
}
