package com.bxm.newidea.component.oss.config;

import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.oss.service.AliyunOssTokenService;
import com.bxm.newidea.component.oss.service.impl.AliyunOSSServiceImpl;
import com.bxm.newidea.component.oss.service.impl.AliyunOssTokenServiceImpl;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 项目配置文件中必须有阿里云oss相关的配置才注册此服务
 */
@Configuration
public class AliyunOssConfiguration {

    @Bean
    @ConditionalOnProperty(prefix = "aliyun.oss", value = "endpoint")
    public AliyunOSSService aliyunOSSService(AliyunOssProperties aliyunOssProperties) {
        return new AliyunOSSServiceImpl(aliyunOssProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix = "aliyun.oss.token", value = "region")
    public AliyunOssTokenService aliyunOssTokenService(AliyunOssTokenProperties aliyunOssTokenProperties) {
        return new AliyunOssTokenServiceImpl(aliyunOssTokenProperties);
    }
}
