package com.bxm.newidea.component.payment.config;

import lombok.Data;

/**
 * 支付宝商户号
 *
 * @author liujia
 * @date 2020/5/31 10:35
 **/
@Data
public class AlipayMchAccount {

    /**
     * 商户号别名
     */
    private String mchAlias;

    /**
     * 商户号描述信息
     */
    private String description;

    /**
     * 商户号ID
     */
    private String mchId;

    /**
     * 商户号私钥（通过工具生成）
     */
    private String privateKey;

    /**
     * 支付宝公钥（通过上传工具生成的公钥后，支付平台提供的公钥，注意不是与私钥配对的公钥）
     */
    private String publicKey;

    /**
     * 签名类型
     */
    private String signType;

    /**
     * 字符编码
     */
    private String charset;
}
