package com.bxm.newidea.component.payment.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;
import java.util.Map;

/**
 * 支付配置项
 *
 * @author liujia
 */
@ConfigurationProperties(prefix = "thirdparty.payment.config")
@Data
public class PaymentProperties {
    /**
     * 微信商户号信息，用于配置多个微信商户信息
     */
    private List<WechatMchAccount> wechatMchAccounts;

    /**
     * 业务场景与微信商户号的绑定关系
     * key ： 业务场景，会根据业务场景去查找公众号，必须保证一一对应
     * value : 商户号别名
     */
    private Map<String, String> wechatMchRelation;

    /**
     * 支付宝商户号配置信息,支持配置多个支付宝商户信息
     */
    private List<AlipayMchAccount> alipayMchAccounts;

    /**
     * 业务场景与商户号的绑定关系
     * key : 业务场景
     * value : 商户别名
     */
    private Map<String, String> alipayMchRelation;

}
